/*
 *  utils.h
 *  CDMaker
 *
 *  Created by Alastair Houghton on 08/08/2005.
 *  Copyright 2005 Coriolis Systems Limited. All rights reserved.
 *
 */

#ifndef UTILS_H_
#define UTILS_H_

#include <sys/types.h>

#include <stdbool.h>
#include <stdint.h>
#include <CoreFoundation/CoreFoundation.h>

#ifndef lengthof
#define lengthof(x) (sizeof (x) / sizeof (*x))
#endif

typedef struct {
  bool recurse : 1;
  bool set_owner : 1;
  bool set_group : 1;
  bool continue_on_error : 1;
  uid_t owner_id;
  gid_t group_id;
  void *context;
  // Function should return false to skip file
  bool (* will_copy_file_fn)(void *context, const char *path);
} copy_file_options_t;

/* Copy attributes from one file to another. */
bool copy_attribs (const char *source,
		   const char *dest,
		   bool is_compressed);

/* Copy a file, preserving all attributes. */
bool copy_file (const char *source,
		const char *dest,
		copy_file_options_t *options);

// Delete a file recursively
int delete_file_object (const char *path);

/* Stringbuf routines */
char *stringbuf_alloc (size_t initial_capacity);
char *stringbuf_dup (const char *string);
void stringbuf_free (char *str);

size_t stringbuf_capacity (char *str);
char *stringbuf_expand (char *str, size_t new_capacity);
char *stringbuf_append (char *str, const char *string);
char *stringbuf_append_path_component (char *str, const char *component);

// Property List Routines
CF_RETURNS_RETAINED CFPropertyListRef plist_from_file (const char *file);

int run_toolx (char **args);
int run_tool (const char *first_arg, ...) __attribute__ ((sentinel));

#endif /* UTILS_H_ */
